package edu.unl.consystlab.gui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;

public class RedFilter extends RGBImageFilter {

    int f=-1; // all
    public RedFilter()
    {
        super();
        canFilterIndexColorModel = true;
        int a = 255<<24;
        int r = 255<<16;
        int g = 255<<8;
        int b = 255<<0;
        f = a|g|b;
    }    
    
    public int filterRGB(int x, int y, int rgb) {
        rgb &= f;
        return rgb;
    }
    
    public static Image filter(Image orig) {
        ImageProducer prod = 
            new FilteredImageSource(orig.getSource(),new RedFilter());
        Image filtered = Toolkit.getDefaultToolkit().createImage(prod);
        return filtered;
    }


}
